<?php

namespace app/models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Customer extends Model 
{

    protected $table = 'customer';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function rate()
    {
        return $this->hasMany('Offerratio', 'customer_id');
    }

    public function offerview()
    {
        return $this->hasMany('Offer');
    }

    public function offerview()
    {
        return $this->hasMany('Offerview');
    }

}