<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOfferItemsTable extends Migration {

	public function up()
	{
		Schema::create('offer_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('itemname');
			$table->string('image');
			$table->string('price');
			$table->integer('offer_id')->unsigned();
			$table->decimal('originalPrice');
			$table->integer('discountPrice');
			$table->integer('percent');
		});
	}

	public function down()
	{
		Schema::drop('offer_items');
	}
}