<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('branch', function(Blueprint $table) {
			$table->foreign('businessactivity_id')->references('id')->on('businessactivity')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('timeofwork', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branch')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('businessactivity', function(Blueprint $table) {
			$table->foreign('businessowner_id')->references('id')->on('businessowners')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('businessactivity', function(Blueprint $table) {
			$table->foreign('businesscategory_id')->references('id')->on('businesscategory')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('offermedia', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('offer')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('keyword', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('offer')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('offer_items', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('offer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('offerrate', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('offerrate', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('businessowners')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('branch', function(Blueprint $table) {
			$table->dropForeign('branch_businessactivity_id_foreign');
		});
		Schema::table('timeofwork', function(Blueprint $table) {
			$table->dropForeign('timeofwork_branch_id_foreign');
		});
		Schema::table('businessactivity', function(Blueprint $table) {
			$table->dropForeign('businessactivity_businessowner_id_foreign');
		});
		Schema::table('businessactivity', function(Blueprint $table) {
			$table->dropForeign('businessactivity_businesscategory_id_foreign');
		});
		Schema::table('offermedia', function(Blueprint $table) {
			$table->dropForeign('offermedia_offer_id_foreign');
		});
		Schema::table('keyword', function(Blueprint $table) {
			$table->dropForeign('keyword_offer_id_foreign');
		});
		Schema::table('offer_items', function(Blueprint $table) {
			$table->dropForeign('offer_items_offer_id_foreign');
		});
		Schema::table('offerrate', function(Blueprint $table) {
			$table->dropForeign('offerrate_customer_id_foreign');
		});
		Schema::table('offerrate', function(Blueprint $table) {
			$table->dropForeign('offerrate_offer_id_foreign');
		});
	}
}