<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function sites()
    {
        return $this->hasMany('App\Model\UserSite');
    }

    public function post_categories()
    {
        return $this->hasMany('App\Model\PostCategory');
    }

}