<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSitesTable extends Migration {

	public function up()
	{
		Schema::create('sites', function(Blueprint $table) {
			$table->increments('id');
			$table->string('domain');
			$table->string('name');
			$table->string('url');
			$table->integer('theme_id')->default('0');
			$table->enum('status', array('active', 'passive'));
			$table->longText('informations');
			$table->text('permission_modules');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('sites');
	}
}