<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGalleryCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('gallery_categories', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('site_id')->default('0');
			$table->string('name');
			$table->integer('user_id')->default('0');
			$table->timestamps();
			$table->enum('status', array('active', 'passive'));
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('gallery_categories');
	}
}