<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('post_categories', function(Blueprint $table) {
			$table->increments('id');
			$table->string('slug');
			$table->string('name');
			$table->enum('status', array('active', 'passive'));
			$table->string('title');
			$table->enum('listing', array('y', 'n'));
			$table->longText('data');
			$table->integer('user_id')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('post_categories');
	}
}