<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'Users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function roles()
	{
		return $this->belongsToMany('Role');
	}

	public function teacher()
	{
		return $this->hasOne('Teacher');
	}

	public function Student()
	{
		return $this->hasOne('Student');
	}

}