<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('User', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('firstname');
			$table->string('lastname');
			$table->string('adresse');
			$table->string('city');
			$table->string('email')->unique();
			$table->string('password');
			$table->rememberToken('rememberToken');
		});
	}

	public function down()
	{
		Schema::drop('User');
	}
}