<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('gammes', function(Blueprint $table) {
			$table->foreign('idEtude')->references('idEtude')->on('Etudes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sousFamille', function(Blueprint $table) {
			$table->foreign('numFamille')->references('id')->on('familles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('operations', function(Blueprint $table) {
			$table->foreign('numSsFamille')->references('id')->on('sousFamille')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('competances', function(Blueprint $table) {
			$table->foreign('numOperation')->references('id')->on('operations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('competances', function(Blueprint $table) {
			$table->foreign('idOuvrier')->references('id')->on('ouvriers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('optsGammes', function(Blueprint $table) {
			$table->foreign('idGamme')->references('id')->on('gammes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('optsGammes', function(Blueprint $table) {
			$table->foreign('idOpts')->references('id')->on('operations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Lignes', function(Blueprint $table) {
			$table->foreign('numCollection')->references('idLigne')->on('Lignes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('SousLignes', function(Blueprint $table) {
			$table->foreign('idLigne')->references('idLigne')->on('Lignes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Etudes', function(Blueprint $table) {
			$table->foreign('idSsLigne')->references('idSsLigne')->on('SousLignes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('gammes', function(Blueprint $table) {
			$table->dropForeign('gammes_idEtude_foreign');
		});
		Schema::table('sousFamille', function(Blueprint $table) {
			$table->dropForeign('sousFamille_numFamille_foreign');
		});
		Schema::table('operations', function(Blueprint $table) {
			$table->dropForeign('operations_numSsFamille_foreign');
		});
		Schema::table('competances', function(Blueprint $table) {
			$table->dropForeign('competances_numOperation_foreign');
		});
		Schema::table('competances', function(Blueprint $table) {
			$table->dropForeign('competances_idOuvrier_foreign');
		});
		Schema::table('optsGammes', function(Blueprint $table) {
			$table->dropForeign('optsGammes_idGamme_foreign');
		});
		Schema::table('optsGammes', function(Blueprint $table) {
			$table->dropForeign('optsGammes_idOpts_foreign');
		});
		Schema::table('Lignes', function(Blueprint $table) {
			$table->dropForeign('Lignes_numCollection_foreign');
		});
		Schema::table('SousLignes', function(Blueprint $table) {
			$table->dropForeign('SousLignes_idLigne_foreign');
		});
		Schema::table('Etudes', function(Blueprint $table) {
			$table->dropForeign('Etudes_idSsLigne_foreign');
		});
	}
}