<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class UserInfo extends Model 
{

    protected $table = 'user_infos';
    public $timestamps = true;

    public function role()
    {
        return $this->hasOne('Role', 'role_id');
    }

    public function department()
    {
        return $this->hasOne('Department', 'department_id');
    }

    public function company()
    {
        return $this->hasOne('Company', 'company_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}