<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Task extends Model 
{

    protected $table = 'tasks';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $visible = array('name');

    public function request()
    {
        return $this->belongsTo('Request', 'request_id');
    }

    public function assignees()
    {
        return $this->hasMany('TaskAssigneeLog', 'task_id');
    }

    public function activities()
    {
        return $this->hasMany('RequestActivityLog', 'task_id');
    }

    public function taskWorklog()
    {
        return $this->hasMany('TaskWorkLog', 'task_id');
    }

}