<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('abbreviation');
			$table->enum('type', array('holding', 'subsidiary', 'vendor'));
			$table->integer('cito_quota')->nullable();
			$table->integer('cito_used');
			$table->datetime('cito_reset_at');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}