<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTasksTable extends Migration {

	public function up()
	{
		Schema::create('tasks', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('request_id')->unsigned();
			$table->integer('creator_id')->unsigned();
			$table->string('name')->nullable();
			$table->string('description')->nullable();
			$table->enum('step', array('to_do', 'in_progress', 'done'));
			$table->datetime('due_date')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('tasks');
	}
}