<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Company extends Eloquent {

	protected $table = 'companies';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function category()
	{
		return $this->hasMany('Category', 'company_id');
	}

	public function citoUselog()
	{
		return $this->hasMany('CompanyCitoUselog', 'company_id');
	}

	public function ticket()
	{
		return $this->hasMany('Request', 'company_id');
	}

	public function status()
	{
		return $this->hasMany('Status', 'company_id');
	}

	public function products()
	{
		return $this->hasMany('Product', 'product_id');
	}

	public function productUses()
	{
		return $this->hasMany('CompanyProductUse', 'company_id');
	}

}