<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Task extends Eloquent {

	protected $table = 'tasks';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $visible = array('name');

	public function request()
	{
		return $this->belongsTo('Request', 'request_id');
	}

	public function assignees()
	{
		return $this->hasMany('TaskAssigneeLog', 'task_id');
	}

	public function activities()
	{
		return $this->hasMany('RequestActivityLog', 'task_id');
	}

	public function taskWorklog()
	{
		return $this->hasMany('TaskWorkLog', 'task_id');
	}

}