<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Company extends Model 
{

    protected $table = 'companies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function category()
    {
        return $this->hasMany('Category', 'company_id');
    }

    public function citoUselog()
    {
        return $this->hasMany('CompanyCitoUselog', 'company_id');
    }

    public function ticket()
    {
        return $this->hasMany('Request', 'company_id');
    }

    public function status()
    {
        return $this->hasMany('Status', 'company_id');
    }

    public function products()
    {
        return $this->hasMany('Product', 'product_id');
    }

    public function productUses()
    {
        return $this->hasMany('CompanyProductUse', 'company_id');
    }

}