<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVolunteerTable extends Migration {

	public function up()
	{
		Schema::create('volunteer', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->timestamps();
			$table->softDeletes();
			$table->string('user_id');
			$table->string('event_id');
			$table->string('status')->default('pending');
			$table->string('duty_description');
		});
	}

	public function down()
	{
		Schema::drop('volunteer');
	}
}