<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('user', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->timestamps();
			$table->softDeletes();
			$table->string('username');
			$table->string('password');
			$table->string('f_name');
			$table->string('m_name');
			$table->string('l_name');
			$table->string('father_name');
			$table->string('mother_name');
			$table->string('gender');
			$table->date('dob');
			$table->string('blood_group');
			$table->string('department');
			$table->string('pa_housename');
			$table->string('pa_postoffice');
			$table->string('pa_locality');
			$table->string('pa_city');
			$table->string('pa_pin');
			$table->string('pa_state');
			$table->string('contact_number');
			$table->string('job_location');
			$table->string('email_id')->unique();
			$table->string('passing_out_year');
			$table->string('whatsapp_number');
			$table->string('job_designation');
			$table->string('ieee_membership_id');
			$table->string('current_ieee_designation');
		});
	}

	public function down()
	{
		Schema::drop('user');
	}
}