<?php

namespace volunteer_portal;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Volunteer extends Eloquent {

	protected $table = 'volunteer';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user_ids()
	{
		return $this->hasMany('User', 'id');
	}

	public function event_id()
	{
		return $this->hasMany('Event', 'id');
	}

}