<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionsTable extends Migration {

	public function up()
	{
		Schema::create('questions', function(Blueprint $table) {
			$table->increments('id');
			$table->increments('topic_id');
			$table->string('title');
			$table->enum('format', array('TrueorFalse', 'FillintheBlank', 'MCQ'));
			$table->enum('level', array('easy', 'medium', 'difficult'));
			$table->enum('status', array('published', 'draft'));
			$table->integer('completion_time');
			$table->timestamps();
			$table->increments('grade_id');
			$table->increments('subject_id');
			$table->increments('chapter_id');
			$table->increments('quest_id');
		});
	}

	public function down()
	{
		Schema::drop('questions');
	}
}