<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTestsTable extends Migration {

	public function up()
	{
		Schema::create('tests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->increments('board_id');
			$table->increments('testable_id');
			$table->enum('testable_type', array('pattern', 'test', 'exam'));
			$table->enum('test_type', array('pattern', 'test', 'exam'));
		});
	}

	public function down()
	{
		Schema::drop('tests');
	}
}