<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('phone');
			$table->string('email')->unique();
			$table->integer('role_id')->unsigned();
			$table->string('password');
			$table->string('remember_token');
			$table->string('lastname');
			$table->string('firstname');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}