<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserVerificationDocsTable extends Migration {

	public function up()
	{
		Schema::create('user_verification_docs', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('verification_request_id')->unsigned()->nullable();
			$table->string('id_type', 50);
			$table->string('image_path', 255);
			$table->string('doc_type', 10);
			$table->string('selfie_location', 255);
			$table->string('buyer_agent_license_no', 100);
			$table->string('buyer_agent_state', 30);
			$table->string('rejection_reason', 255);
			$table->boolean('verification_status');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_verification_docs');
	}
}