<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('periodes', function(Blueprint $table) {
			$table->foreign('id_annescolaire')->references('id')->on('annee_scolaires')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('classes', function(Blueprint $table) {
			$table->foreign('id_niveaus')->references('id')->on('niveaus')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('eleves', function(Blueprint $table) {
			$table->foreign('id_class')->references('id')->on('classes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('parents', function(Blueprint $table) {
			$table->foreign('id_typeparent')->references('id')->on('type_parents')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('parents', function(Blueprint $table) {
			$table->foreign('id_eleves')->references('id')->on('eleves')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('unites', function(Blueprint $table) {
			$table->foreign('id_typeunites')->references('id')->on('type_unites')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('matieres', function(Blueprint $table) {
			$table->foreign('id_unites')->references('id')->on('unites')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('controles', function(Blueprint $table) {
			$table->foreign('id_periode')->references('id')->on('periodes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('controles', function(Blueprint $table) {
			$table->foreign('id_matieres')->references('id')->on('matieres')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('controles', function(Blueprint $table) {
			$table->foreign('id_professeur')->references('id')->on('professeurs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('examens', function(Blueprint $table) {
			$table->foreign('id_periode')->references('id')->on('periodes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('examens', function(Blueprint $table) {
			$table->foreign('id_unite')->references('id')->on('unites')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('livres', function(Blueprint $table) {
			$table->foreign('id_niveaus')->references('id')->on('niveaus')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('periodes', function(Blueprint $table) {
			$table->dropForeign('periodes_id_annescolaire_foreign');
		});
		Schema::table('classes', function(Blueprint $table) {
			$table->dropForeign('classes_id_niveaus_foreign');
		});
		Schema::table('eleves', function(Blueprint $table) {
			$table->dropForeign('eleves_id_class_foreign');
		});
		Schema::table('parents', function(Blueprint $table) {
			$table->dropForeign('parents_id_typeparent_foreign');
		});
		Schema::table('parents', function(Blueprint $table) {
			$table->dropForeign('parents_id_eleves_foreign');
		});
		Schema::table('unites', function(Blueprint $table) {
			$table->dropForeign('unites_id_typeunites_foreign');
		});
		Schema::table('matieres', function(Blueprint $table) {
			$table->dropForeign('matieres_id_unites_foreign');
		});
		Schema::table('controles', function(Blueprint $table) {
			$table->dropForeign('controles_id_periode_foreign');
		});
		Schema::table('controles', function(Blueprint $table) {
			$table->dropForeign('controles_id_matieres_foreign');
		});
		Schema::table('controles', function(Blueprint $table) {
			$table->dropForeign('controles_id_professeur_foreign');
		});
		Schema::table('examens', function(Blueprint $table) {
			$table->dropForeign('examens_id_periode_foreign');
		});
		Schema::table('examens', function(Blueprint $table) {
			$table->dropForeign('examens_id_unite_foreign');
		});
		Schema::table('livres', function(Blueprint $table) {
			$table->dropForeign('livres_id_niveaus_foreign');
		});
	}
}